#ifndef REMAPPER_H
#define REMAPPER_H

#include "stdafx.h"
#include "max.h"
#include "Warnings.h"

typedef struct{
    int vertexIndex;
    int textureIndex;
    int colorIndex;
    int faceIndex;
    int origFace;
    char triIndex;
    unsigned int smGroup;
    unsigned int usedSMGroup;
    int matID;
    BOOL backface;
    float x, y, z;
    float u, v;
    RwUInt8 r, g, b;
}ReMapperInfo;

typedef struct{
    int faceNum;
    int index[3];
}ReMapperFaceLoop;

typedef struct{
    int vertexIndex;
    int textureIndex;
    int colorIndex;
    int faceIndex;
    float u, v;
    unsigned int smGroup;
    BOOL backface;
}ReMapperVertex;

class ReMapper
{
public:
    ReMapper(void);
    ~ReMapper(void);

    BOOL                DoRemap(Mesh *mesh, Mtl *mat, BOOL limitUVs, 
                                int uvMax, float weldThreshold, float weldThresholdUV,
                                BOOL export2SidedMaterials, BOOL maintainBackfaceNormals,
                                BOOL weldVertices, WarningList *warnings);
    void                InitReMapperInfos(ReMapperInfo *infos, int numInfos);
    void                ResetReMap(void);
    int                 GetNumVertices(void);
    int                 GetNumFaces(void);
    ReMapperFaceLoop *  GetFace(int faceNum);
    ReMapperVertex *    GetVertex(int vertexNum);    

private:
    void                WriteCurrentFace( bool isBackFace,
                                          int faceIndex,
                                          int backfaceindex,
                                          int faceNum,
                                          Mesh *mesh,
                                          UVVert transformedUV[3] );
    int                 m_numVertices;
    int                 m_numFaces;
    ReMapperVertex *    m_vertices;
    ReMapperFaceLoop *  m_faces;
    
    //Private temporary information
    ReMapperInfo *      m_currentMap;
    unsigned int *      m_vertSMGroups;
    unsigned int *      m_vertSMGroupsTemp;
    float               m_limituvoffsetu;
    float               m_limituvoffsetv;
};

#endif /* REMAPPER_H*/
